% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe3_sp.R
\name{SISe3_sp}
\alias{SISe3_sp}
\title{Create a SISe3_sp model}
\usage{
SISe3_sp(u0, tspan, events = NULL, phi = NULL, upsilon_1 = NULL,
  upsilon_2 = NULL, upsilon_3 = NULL, gamma_1 = NULL, gamma_2 = NULL,
  gamma_3 = NULL, alpha = NULL, beta_t1 = NULL, beta_t2 = NULL,
  beta_t3 = NULL, beta_t4 = NULL, end_t1 = NULL, end_t2 = NULL,
  end_t3 = NULL, end_t4 = NULL, distance = NULL, coupling = NULL)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each
node, see details.}

\item{tspan}{An increasing sequence of points in time where the
state of the system is to be returned.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{siminf_model}}.}

\item{phi}{A numeric vector with the initial environmental
infectious pressure in each node. Default NULL which gives 0 in
each node.}

\item{upsilon_1}{Indirect transmission rate of the environmental
infectious pressure in age category 1}

\item{upsilon_2}{Indirect transmission rate of the environmental
infectious pressure in age category 2}

\item{upsilon_3}{Indirect transmission rate of the environmental
infectious pressure in age category 3}

\item{gamma_1}{The recovery rate from infected to susceptible for
age category 1}

\item{gamma_2}{The recovery rate from infected to susceptible for
age category 2}

\item{gamma_3}{The recovery rate from infected to susceptible for
age category 3}

\item{alpha}{Shed rate from infected individuals}

\item{beta_t1}{The decay of the environmental infectious pressure
in interval 1.}

\item{beta_t2}{The decay of the environmental infectious pressure
in interval 2.}

\item{beta_t3}{The decay of the environmental infectious pressure
in interval 3.}

\item{beta_t4}{The decay of the environmental infectious pressure
in interval 4.}

\item{end_t1}{The non-inclusive day that ends interval 1.}

\item{end_t2}{The non-inclusive day that ends interval 2.}

\item{end_t3}{The non-inclusive day that ends interval 3.}

\item{end_t4}{The non-inclusive day that ends interval 4.}

\item{distance}{The distance matrix between neighboring nodes}

\item{coupling}{The coupling between neighboring nodes}
}
\value{
\code{SISe3_sp}
}
\description{
Create a SISe3_sp model to be used by the simulation framework.
}
\details{
The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S_1}{The number of sucsceptible in age category 1}
\item{I_1}{The number of infected in age category 1}
\item{S_2}{The number of sucsceptible in age category 2}
\item{I_2}{The number of infected in age category 2}
\item{S_3}{The number of sucsceptible in age category 3}
\item{I_3}{The number of infected in age category 3}
}
}
\section{Beta}{

The time dependent beta is divided into four intervals of the year
\preformatted{
where 0 <= day < 365

Case 1: END_1 < END_2 < END_3 < END_4
INTERVAL_1 INTERVAL_2     INTERVAL_3     INTERVAL_4     INTERVAL_1
[0, END_1) [END_1, END_2) [END_2, END_3) [END_3, END_4) [END_4, 365)

Case 2: END_3 < END_4 < END_1 < END_2
INTERVAL_3 INTERVAL_4     INTERVAL_1     INTERVAL_2     INTERVAL_3
[0, END_3) [END_3, END_4) [END_4, END_1) [END_1, END_2) [END_2, 365)

Case 3: END_4 < END_1 < END_2 < END_3
INTERVAL_4 INTERVAL_1     INTERVAL_2     INTERVAL_3     INTERVAL_4
[0, END_4) [END_4, END_1) [END_1, END_2) [END_2, END_3) [END_3, 365)
}
}

