% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R, R/SimInf_model.R, R/SEIR.R,
%   R/SIR.R, R/SISe.R, R/SISe3.R, R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{plot-methods}
\alias{plot-methods}
\alias{plot}
\alias{plot,SimInf_events-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SimInf_model-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SEIR-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SIR-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe3-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe3_sp-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe_sp-method}
\title{Plot \code{\linkS4class{SimInf_events}}}
\usage{
\S4method{plot}{SimInf_events}(x, frame.plot = FALSE, ...)

\S4method{plot}{SimInf_model}(x, legend = NULL, col = NULL, lty = NULL,
  lwd = 2, N = FALSE, compartments = NULL, spaghetti = FALSE, ...)

\S4method{plot}{SEIR}(x, col = c("blue", "orange", "red", "darkgreen"),
  lty = rep(1, 4), lwd = 2, ...)

\S4method{plot}{SIR}(x, col = c("blue", "red", "darkgreen"), lty = rep(1,
  3), lwd = 2, ...)

\S4method{plot}{SISe}(x, col = c("blue", "red"), lty = rep(1, 2), lwd = 2,
  ...)

\S4method{plot}{SISe3}(x, legend = expression(S[1], I[1], S[2], I[2], S[3],
  I[3]), col = rep(c("blue", "red"), 3), lty = rep(1:3, each = 2),
  lwd = 2, ...)

\S4method{plot}{SISe3_sp}(x, legend = expression(S[1], I[1], S[2], I[2], S[3],
  I[3]), col = rep(c("blue", "red"), 3), lty = rep(1:3, each = 2),
  lwd = 2, ...)

\S4method{plot}{SISe_sp}(x, col = c("blue", "red"), lty = rep(1, 2),
  lwd = 2, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{frame.plot}{Draw a frame around each plot. Default is FALSE.}

\item{...}{Additional arguments affecting the plot produced.}

\item{legend}{The character vector to appear in the
legend. Default is to use the names of the compartments.}

\item{col}{The plotting color for each compartment. Default is
black.}

\item{lty}{The line type for each compartment. Default is the
sequence: 1=solid, 2=dashed, 3=dotted, 4=dotdash, 5=longdash,
6=twodash.}

\item{lwd}{The line width for each compartment. Default is 2.}

\item{N}{if \code{TRUE}, the average number of individuals in each
compartment, else the proportion of individuals in each
compartment.  Default is \code{FALSE}.}

\item{compartments}{Character vector with the compartments in the
model to include in the plot. Default is \code{NULL}
i.e. include all compartments in the model.}

\item{spaghetti}{Plot one line for each node. Default is
\code{FALSE}.}
}
\description{
Plot \code{\linkS4class{SimInf_events}}

Plot \code{\linkS4class{SimInf_model}}
}
\examples{
## Create an 'SIR' model with 10 nodes and initialise
## it with 99 susceptible individuals and one infected
## individual. Let the model run over 100 days.
model <- SIR(u0 = data.frame(S = rep(99, 10),
                             I = rep(1, 10),
                             R = rep(0, 10)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model, threads = 1, seed = 1)

## Plot the proportion of susceptible, infected and recovered
## individuals.
plot(result)

## Plot the number of susceptible, infected and recovered
## individuals.
plot(result, N = TRUE)

## Plot the number of infected individuals.
plot(result, compartments = "I", N = TRUE)
}
