% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R, R/abc.R
\name{run}
\alias{run}
\alias{run,SimInf_model-method}
\alias{run,SEIR-method}
\alias{run,SIR-method}
\alias{run,SISe-method}
\alias{run,SISe3-method}
\alias{run,SISe3_sp-method}
\alias{run,SISe_sp-method}
\alias{run,SimInf_abc-method}
\title{Run the SimInf stochastic simulation algorithm}
\usage{
run(model, ...)

\S4method{run}{SimInf_model}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SEIR}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SIR}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SISe}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SISe3}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SISe3_sp}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SISe_sp}(model, solver = c("ssm", "aem"), ...)

\S4method{run}{SimInf_abc}(model, ...)
}
\arguments{
\item{model}{The SimInf model to run.}

\item{...}{Additional arguments.}

\item{solver}{Which numerical solver to utilize. Default is 'ssm'.}
}
\value{
\code{\link{SimInf_model}} object with result from
    simulation.
}
\description{
Run the SimInf stochastic simulation algorithm
}
\examples{
## Create an 'SIR' model with 10 nodes and initialise
## it to run over 100 days.
model <- SIR(u0 = data.frame(S = rep(99, 10),
                             I = rep(1, 10),
                             R = rep(0, 10)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model)

## Plot the proportion of susceptible, infected and recovered
## individuals.
plot(result)
}
\references{
\Widgren2019

\Bauer2016

\Bauer2015
}
