% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIR.R
\name{u0_SEIR}
\alias{u0_SEIR}
\title{Example data to initialize the \sQuote{SEIR} model}
\usage{
u0_SEIR()
}
\value{
A \code{data.frame}
}
\description{
Example data to initialize a population of 1600 nodes and
demonstrate the \code{\linkS4class{SEIR}} model.
}
\details{
A \code{data.frame} with the number of individuals in the
\sQuote{S}, \sQuote{E}, \sQuote{I} and \sQuote{R} compartments in
1600 nodes. Note that the \sQuote{E}, \sQuote{I} and \sQuote{R}
compartments are zero.
}
\examples{
## Create an 'SEIR' model with 1600 nodes and initialize it to
## run over 4*365 days and record data at weekly time-points.
## Add ten infected individuals to the first node.
u0 <- u0_SEIR()
u0$I[1] <- 10
tspan <- seq(from = 1, to = 4*365, by = 7)
model <- SEIR(u0      = u0,
              tspan   = tspan,
              events  = events_SEIR(),
              beta    = 0.16,
              epsilon = 0.25,
              gamma   = 0.01)

## Run the model to generate a single stochastic trajectory.
result <- run(model)
plot(result)

## Summarize trajectory
summary(result)
}
