% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{trajectory,SimInf_model-method}
\alias{trajectory,SimInf_model-method}
\title{Extract data from a simulated trajectory}
\usage{
\S4method{trajectory}{SimInf_model}(model, compartments, index, format = c("data.frame", "matrix"))
}
\arguments{
\item{model}{the \code{SimInf_model} object to extract the result
from.}

\item{compartments}{specify the names of the compartments to
extract data from. The compartments can be specified as a
character vector e.g. \code{compartments = c('S', 'I', 'R')},
or as a formula e.g. \code{compartments = ~S+I+R} (see
\sQuote{Examples}). Default (\code{compartments=NULL}) is to
extract the number of individuals in each compartment i.e. the
data from all discrete state compartments in the model. In
models that also have continuous state variables e.g. the
\code{SISe} model, they are also included.}

\item{index}{indices specifying the subset of nodes to include
when extracting data. Default (\code{index = NULL}) is to
extract data from all nodes.}

\item{format}{the default (\code{format = "data.frame"}) is to
generate a \code{data.frame} with one row per node and
time-step with the number of individuals in each
compartment. Using \code{format = "matrix"} returns the result
as a matrix, which is the internal format (see
\sQuote{Details}).}
}
\value{
A \code{data.frame} if \code{format = "data.frame"}, else
    a matrix.
}
\description{
Extract the number of individuals in each compartment in every
node after generating a single stochastic trajectory with
\code{\link{run}}.
}
\section{Internal format of the discrete state variables}{

    Description of the layout of the internal matrix (\code{U})
    that is returned if \code{format = "matrix"}. \code{U[, j]}
    contains the number of individuals in each compartment at
    \code{tspan[j]}. \code{U[1:Nc, j]} contains the number of
    individuals in node 1 at \code{tspan[j]}. \code{U[(Nc + 1):(2
    * Nc), j]} contains the number of individuals in node 2 at
    \code{tspan[j]} etc, where \code{Nc} is the number of
    compartments in the model. The dimension of the matrix is
    \eqn{N_n N_c \times} \code{length(tspan)} where \eqn{N_n} is
    the number of nodes.
}

\section{Internal format of the continuous state variables}{

    Description of the layout of the matrix that is returned if
    \code{format = "matrix"}. The result matrix for the
    real-valued continuous state. \code{V[, j]} contains the
    real-valued state of the system at \code{tspan[j]}. The
    dimension of the matrix is \eqn{N_n}\code{dim(ldata)[1]}
    \eqn{\times} \code{length(tspan)}.
}

\examples{
## Create an 'SIR' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6, R = rep(0, 6))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Run the model to generate a single stochastic trajectory.
result <- run(model)

## Extract the number of individuals in each compartment at the
## time-points in 'tspan'.
trajectory(result)

## Extract the number of recovered individuals in the first node
## at the time-points in 'tspan'.
trajectory(result, compartments = "R", index = 1)

## Extract the number of recovered individuals in the first and
## third node at the time-points in 'tspan'.
trajectory(result, compartments = "R", index = c(1, 3))

## Create an 'SISe' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6)
model <- SISe(u0 = u0, tspan = 1:10, phi = rep(0, 6),
    upsilon = 0.02, gamma = 0.1, alpha = 1, epsilon = 1.1e-5,
    beta_t1 = 0.15, beta_t2 = 0.15, beta_t3 = 0.15, beta_t4 = 0.15,
    end_t1 = 91, end_t2 = 182, end_t3 = 273, end_t4 = 365)

## Run the model
result <- run(model)

## Extract the continuous state variable 'phi' which represents
## the environmental infectious pressure.
trajectory(result, "phi")
}
