% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findintercorr_pois_nb.R
\name{findintercorr_pois_nb}
\alias{findintercorr_pois_nb}
\title{Calculate Intermediate MVN Correlation for Poisson - Negative Binomial Variables: Correlation Method 1}
\usage{
findintercorr_pois_nb(rho_pois_nb, lam, size, prob, mu = NULL,
  nrand = 1e+05, seed = 1234)
}
\arguments{
\item{rho_pois_nb}{a \code{k_pois x k_nb} matrix of target correlations}

\item{lam}{a vector of lambda (> 0) constants for the Poisson variables (see \code{\link[stats]{dpois}})}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{dnbinom}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL)}

\item{nrand}{the number of random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
the \code{k_pois x k_nb} intermediate correlation matrix whose rows represent the \code{k_pois} Poisson variables and
    columns represent the \code{k_nb} Negative Binomial variables
}
\description{
This function calculates a \code{k_pois x k_nb} intermediate matrix of correlations for the
    Poisson and Negative Binomial variables by extending the method of Yahav & Shmueli (2012, \doi{10.1002/asmb.901}). The intermediate correlation
    between Z1 and Z2 (the standard normal variables used to generate the Poisson and Negative Binomial variables Y1 and Y2
    via the inverse cdf method) is calculated using a logarithmic transformation of the target correlation.
    First, the upper and lower Frechet-Hoeffding bounds (mincor, maxcor) on \eqn{\rho_{y1,y2}} are simulated.
    Then the intermediate correlation is found as follows:
    \deqn{\rho_{z1,z2} = (1/b) * log((\rho_{y1,y2} - c)/a)}, where \eqn{a = -(maxcor * mincor)/(maxcor + mincor)},
    \eqn{b = log((maxcor + a)/a)}, and \eqn{c = -a}.  The function adapts code from Amatya & Demirtas' (2016) package
    \code{\link[PoisNor]{PoisNor}} by:

    1) allowing specifications for the number of random variates and the seed for reproducibility

    2) providing the following checks: if \eqn{\rho_{z1,z2}} >= 1, \eqn{\rho_{z1,z2}} is set to 0.99; if \eqn{\rho_{z1,z2}} <= -1,
    \eqn{\rho_{z1,z2}} is set to -0.99

    3) simulating Negative Binomial variables.
    The function is used in \code{\link[SimMultiCorrData]{findintercorr}} and \code{\link[SimMultiCorrData]{rcorrvar}}.
    This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{findintercorr_pois}}.
}
\seealso{
\code{\link[PoisNor]{PoisNor}}, \code{\link[SimMultiCorrData]{findintercorr_pois}},
    \code{\link[SimMultiCorrData]{findintercorr_nb}},
    \code{\link[SimMultiCorrData]{findintercorr}}, \code{\link[SimMultiCorrData]{rcorrvar}}
}
\keyword{1}
\keyword{Binomial,}
\keyword{Negative}
\keyword{Poisson,}
\keyword{correlation,}
\keyword{intermediate,}
\keyword{method}
