% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf_functions.R
\name{genos2sparseMatrix}
\alias{genos2sparseMatrix}
\title{Convert genotypes to haplotypes.}
\usage{
genos2sparseMatrix(genotypes)
}
\arguments{
\item{genotypes}{A dataframe or matrix of genotypes.  The columns of \code{genotypes} are assumed to be individuals (i.e. a diploid human) and the rows are assumed to be mutations.  See details.}
}
\value{
A sparseMatrix.  Note that the rows and columns of the returned matrix have been transposed so that individual haplotypes are rows, and each column represents an SNV.
}
\description{
This function may be used to convert phased genotype data for diplod organisms into a sparse matrix.
}
\details{
The columns of \code{genotypes} are assumed to be individuals (i.e. a diploid human) and the rows are assumed to be mutations.  Thus, the (i,j)th entry of \code{genotypes} is the genotype of the jth person at the ith SNV site.  Please note that \code{genotypes} should not contain missing values.  Additionally, genotypes may take one of the following three forms:
\itemize{
\item "0|0" if the individual is homozygous for the reference allele,
\item "0|1" or "0|1" if the individual is heterozygous for the alternate allele,
\item "1|1" if the individual is homozygous for the alternate allele.
}
}
