% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_seqFunctions.R
\name{sim_seq}
\alias{sim_seq}
\title{Simulate sequence data for a pedigree}
\usage{
sim_seq(ped_file, founder_genos, SNV_map, chrom_map, RV_marker,
  burn_in = 1000, gamma_params = c(2.63, 2.63/0.5))
}
\arguments{
\item{ped_file}{Data frame. A single pedigree. Must match format of pedigree simulated by sim_RVped}

\item{founder_genos}{Dataframe.  A dataframe with rows corresponding to founders, and columns corresponding to markers.  Markers must be listed in same order as \code{SNV_map}.}

\item{SNV_map}{Data frame. A data frame that catalogs the SNVs in \code{haplos}.  If the \code{\link{read_slim}} function was used to import SLiM data to \code{R}, the data frame \code{Mutations} is of the proper format for \code{SNV_map}.  However, users must add the variable \code{is_CRV} to this data frame, see details.}

\item{chrom_map}{Data.frame.  A data.frame consisting of three columns: column 1 contains the chromosome numbers, column 2 start postion of chromosome (in cM), column 3 end position of chromosome (in cM).}

\item{RV_marker}{character. The marker name of the RV locus.}

\item{burn_in}{Numeric. The "burn-in" distance in centiMorgan, as defined by Voorrips and Maliepaard (2012), which is required before simulating the location of the first chiasmata with interference. By default, \code{burn_in = 1000}.
The burn in distance in cM. By default, \code{burn_in = 1000}.}

\item{gamma_params}{Numeric list of length 2. The respective shape and rate parameters of the gamma distribution used to simulate distance between chiasmata.  By default, \code{gamma} \code{_params} \code{= c(2.63, 2*2.63)}, as discussed in Voorrips and Maliepaard (2012).}
}
\value{
offspring_sequences
}
\description{
Simulate sequence data for a pedigree
}
\keyword{internal}
