% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSimReg.R
\name{multi_sim_reg}
\alias{multi_sim_reg}
\title{Similarity regression on multiple \code{y} vectors}
\usage{
multi_sim_reg(ontology, x, y, g = matrix(0, nrow = nrow(y), ncol = ncol(y)),
  lit_sim_mat = NULL, summary_function = summary, simplify = FALSE,
  mc_cores = 1L, information_content = get_term_info_content(ontology,
  term_sets = x),
  term_descendancy_matrix = get_term_descendancy_matrix(ontology,
  names(information_content)), term_sim_mat = prune_sim_mat(ontology,
  get_term_sim_mat(ontology, information_content, term_descendancy_matrix =
  term_descendancy_matrix)), ...)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{x}{List of character vectors of terms IDs.}

\item{y}{Logical matrix of genotypes (typically TRUE for rare genotype, FALSE for common genotype).}

\item{g}{Genotype log odds offset per individual.}

\item{lit_sim_mat}{Numeric matrix of prior weights for terms inclusion in phi for each row of \code{y}, where the columns match to those in \code{term_sim_mat}. Thus, must have exactly the same number of rows as \code{y}, and same number of columns as \code{term_sim_mat}. Defaults to 'all equal' (=1).}

\item{summary_function}{Function to apply to the samples generated conditioning on each row of \code{y}.}

\item{simplify}{Logical value determining whether result is simplified by using \code{rbind} to turn it into a \code{data.frame}.}

\item{mc_cores}{Number of cores to use - passed to \code{mcmapply} function.}

\item{information_content}{Numeric vector, named by HPO IDs, containing the information content of corresponding terms.}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}

\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{...}{Other arguments to be passed to \code{\link{sim_reg}}.}
}
\value{
List or data frame of summarised output of \code{\link{sim_reg}}.
}
\description{
Applies \code{\link{sim_reg}} regression to multiple binary 'genotypes', \code{y}, encoded in a logical matrix having the individual binary genotypes as rows, against the same set of ontological 'phenotypes'. Thus, the individual subject's genotypes occupy the columns of \code{y} and the number of columns is equal to the length of the list of phenotypes \code{x}. The user can supply a function to be applied to the \code{sim_reg_samples} object for each completed inference. Suitable choices for the function include \code{\link{summary}} (default) and \code{identity} (though identity will lead to extremely large objects if there are many rows in the \code{y} matrix); the number of cores to use.
}

