% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_sim.R
\name{vis_sim}
\alias{vis_sim}
\title{Make a flexdashboard for visualizing the simulation}
\usage{
vis_sim(sim, ...)
}
\arguments{
\item{sim}{Object produced by \code{\link{sim_abundance}}, \code{\link{sim_distribution}},
\code{\link{sim_survey}} or \code{\link{test_surveys}}.}

\item{...}{Additional arguments to send to \link[rmarkdown]{run}}
}
\description{
Assumes the working directory is the project directory
}
\examples{

\donttest{

if (interactive()) {

  pop <- sim_abundance(ages = 1:20, years = 1:20)
  vis_sim(pop)

  dist <- sim_distribution(pop, grid = make_grid(res = c(10, 10)))
  vis_sim(dist)

  ## Run one survey design
  survey <- sim_survey(dist, n_sims = 5)
  vis_sim(survey)

  ## Run several survey designs and assess stratified estimates
  ## (Note: total number of simulations are low to decrease computation time for the example)
  surveys <- expand_surveys(set_den = c(1, 2) / 1000,
                            lengths_cap = c(100, 500),
                            ages_cap = c(5, 20))
  tests <- test_surveys(dist, surveys = surveys, keep_details = 1,
                        n_sims = 5, n_loops = 5, cores = 1)
  vis_sim(tests)

}
}

}
