% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim.R
\name{plot_trend}
\alias{plot_trend}
\alias{plot_surface}
\alias{plot_grid}
\alias{plot_distribution}
\alias{plot_survey}
\alias{plot_total_strat_fan}
\alias{plot_length_strat_fan}
\alias{plot_age_strat_fan}
\alias{plot_error_surface}
\alias{plot_survey_rank}
\title{Simple plotting functions}
\usage{
plot_trend(sim, sum_ages = sim$ages, col = viridis::viridis(1), ...)

plot_surface(sim, mat = "N", xlab = "Age", ylab = "Year", zlab = mat, ...)

plot_grid(grid, ...)

plot_distribution(
  sim,
  ages = sim$ages,
  years = sim$years,
  type = "contour",
  scale = "natural",
  ...
)

plot_survey(sim, which_year = 1, which_sim = 1)

plot_total_strat_fan(sim, surveys = 1:5, quants = seq(90, 10, by = -10), ...)

plot_length_strat_fan(
  sim,
  surveys = 1:5,
  years = 1:10,
  lengths = 1:50,
  select_by = "year",
  quants = seq(90, 10, by = -10),
  ...
)

plot_age_strat_fan(
  sim,
  surveys = 1:5,
  years = 1:10,
  ages = 1:10,
  select_by = "year",
  quants = seq(90, 10, by = -10),
  ...
)

plot_error_surface(sim, plot_by = "rule")

plot_survey_rank(sim, which_strat = "age")
}
\arguments{
\item{sim}{Object returned by \code{\link{sim_abundance}},
\code{\link{sim_distribution}}, etc.}

\item{sum_ages}{Sum across these ages}

\item{col}{Plot color}

\item{...}{Additional arguments to pass to \code{\link[plotly]{plot_ly}}.}

\item{mat}{Name of matrix in \code{sim} list to plot.}

\item{xlab, ylab, zlab}{Axes labels.}

\item{grid}{Grid produced by \code{\link{make_grid}}.}

\item{ages}{Subset data to one or more ages.}

\item{years}{Subset data to one or more years.}

\item{type}{Plot type: "contour" or "heatmap".}

\item{scale}{Plot response on "natural" or "log" scale?}

\item{which_year}{Subset to specific year}

\item{which_sim}{Subset to specific sim}

\item{surveys}{Subset data to one or more surveys.}

\item{quants}{Quantile intervals to display on fan plot}

\item{lengths}{Subset data to one or more length groups.}

\item{select_by}{Select plot by "age", "length" or "year"?}

\item{plot_by}{Plot error surface by "rule" or "samples"?}

\item{which_strat}{Which strat values to focus on? (total, length, or age)}
}
\value{
Returns a plot of class \code{plotly}.
}
\description{
These functions are simple plotting helpers to get some quick
visuals of values produced by \code{\link{sim_abundance}},
\code{\link{sim_distribution}}, etc.
}
