% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree_test.R
\name{agree_test}
\alias{agree_test}
\title{Tests for Absolute Agreement}
\usage{
agree_test(x, y, delta, conf.level = 0.95, agree.level = 0.95)
}
\arguments{
\item{x}{Vector with first measurement}

\item{y}{Vector with second measurement}

\item{delta}{The threshold below which methods agree/can be considered equivalent, can be in any units. Equivalence Bound for Agreement.}

\item{conf.level}{the confidence level required. Default is 95\%.}

\item{agree.level}{the agreement level required. Default is 95\%. The proportion of data that should lie between the thresholds, for 95\% limits of agreement this should be 0.95.}
}
\value{
Returns single list with the results of the agreement analysis.

\describe{
  \item{\code{"shieh_test"}}{The TOST hypothesis test as described by Shieh.}
  \item{\code{"ccc.xy"}}{Lin's concordance correlation coefficient and confidence intervals.}
  \item{\code{"s.shift"}}{Scale shift from x to y.}
  \item{\code{"l.shift"}}{Location shift from x to y.}
  \item{\code{"bias"}}{a bias correction factor that measures how far the best-fit line deviates from a line at 45 degrees. No deviation from the 45 degree line occurs when bias = 1. See Lin 1989, page 258.}
  \item{\code{"loa"}}{Data frame containing the limits of agreement calculations}
  \item{\code{"h0_test"}}{Decision from hypothesis test.}
  \item{\code{"identity.plot"}}{Plot of x and y with a line of identity with a linear regression line}
  \item{\code{"bland_alt.plot"}}{Simple Bland-Altman plot. Red line are the upper and lower bounds for shieh test; grey box is the acceptable limits (delta). If the red lines are within the grey box then the shieh test should indicate 'reject h0', or to reject the null hypothesis that this not acceptable agreement between x & y.}

}
}
\description{
The agree_test function calculates a variety of agreement statistics. The hypothesis test of agreement is calculated by the method described by Shieh (2019). Bland-Altman limits of agreement, and confidence intervals, are also provided (Bland & Altman 1999; Bland & Altman 1986). In addition, the concordance correlation coefficient (CCC; Lin 1989) is also provided.
}
\section{References}{

Shieh (2019). Assessing Agreement Between Two Methods of Quantitative Measurements: Exact Test Procedure and Sample Size Calculation, Statistics in Biopharmaceutical Research, <https://doi.org/10.1080/19466315.2019.1677495>

Bland, J. M., & Altman, D. G. (1999). Measuring agreement in method comparison studies. Statistical methods in medical research, 8(2), 135-160.

Bland, J. M., & Altman, D. (1986). Statistical methods for assessing agreement between two methods of clinical measurement. The lancet, 327(8476), 307-310.

Lawrence, I., & Lin, K. (1989). A concordance correlation coefficient to evaluate reproducibility. Biometrics, 255-268.
}

\examples{
data('reps')
agree_test(x=reps$x, y=reps$y, delta = 2)

}
