% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tolerance_limit.R
\name{tolerance_limit}
\alias{tolerance_limit}
\title{Tolerance Limits from an Agreement Study}
\usage{
tolerance_limit(
  data,
  x,
  y,
  id = NULL,
  condition = NULL,
  time = NULL,
  pred_level = 0.95,
  tol_level = 0.95,
  tol_method = c("approx", "perc"),
  prop_bias = FALSE,
  log_tf = FALSE,
  cor_type = c("sym", "car1", "ar1", "none"),
  correlation = NULL,
  weights = NULL,
  keep_model = TRUE,
  replicates = 999
)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{x}{Name of the column for the first measurement.}

\item{y}{Name of the column for the second measurement.}

\item{id}{Name of the column for the subject ID.}

\item{condition}{Name of the column indicating different conditions subjects were tested under. This can be left missing if there are no differing conditions to be tested.}

\item{time}{Name of the column indicating the time points. Only necessary if the data is from time series or repeated measures collection.}

\item{pred_level}{Prediction level for the prediction interval. Default is 95\%.}

\item{tol_level}{Tolerance level for the tolerance limit (i.e., the CI of the prediction limit). Default is 95\%.}

\item{tol_method}{Method for calculating the tolerance interval. Options are "approx" for a chi-square based approximation and "perc" for a parametric percentile bootstrap method.}

\item{prop_bias}{Whether to include a proportional bias term in the model. Determines whether proportional bias should be considered for the prediction/tolerance limits calculations.}

\item{log_tf}{Calculate limits of agreement using log-transformed data.}

\item{cor_type}{The type of correlation structure. "sym" is for Compound Symmetry, "car1" is for continuous autocorrelation structure of order 1, or "ar1" for autocorrelation structure of order 1.}

\item{correlation}{an optional corStruct object describing the within-group correlation structure that overrides the default setting. See the documentation of corClasses for a description of the available corStruct classes. If a grouping variable is to be used, it must be specified in the form argument to the corStruct constructor. Defaults to NULL.}

\item{weights}{an optional varFunc object or one-sided formula describing the within-group heteroskedasticity structure that overrides the default setting. If given as a formula, it is used as the argument to varFixed, corresponding to fixed variance weights. See the documentation on varClasses for a description of the available varFunc classes.}

\item{keep_model}{Logical indicator to retain the GLS model. Useful when working with large data and the model is very large.}

\item{replicates}{The number of bootstrap replicates. Passed on to the boot function. Default is 999.}
}
\value{
Returns single \code{tolerance_delta} class object with the results of the agreement analysis with a prediction interval and tolerance limits.
\itemize{
\item \code{limits}: A data frame containing the prediction/tolerance limits.
\item \code{model}: The GLS model; NULL if keep_model set to FALSE.
\item \code{call}: The matched call.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A function for calculating tolerance limits for the difference between two measurements (difference = x-y).
This is a procedure that should produce results similar to the Bland-Altman limits of agreement.
See vignettes for more details.
}
\details{
The tolerance limits calculated in this function are based on the papers by Francq & Govaerts (2016), Francq, et al. (2019), and Francq, et al. (2020).
When \code{tol_method} is set to "approx", the tolerance limits are calculated using the approximation detailed in Francq et al. (2020).
However, these are only an approximation and conservative.
Therefore, as suggested by Francq, et al. (2019), a parametric bootstrap approach can be utilized to calculate percentile tolerance limits (\code{tol_method = "perc"}).
}
\examples{
data('reps')

# Simple
tolerance_limit(x = "x", y ="y", data = reps)

# Nested
tolerance_limit(x = "x", y ="y", data = reps, id = "id")

}
\references{
Francq, B. G., & Govaerts, B. (2016). How to regress and predict in a Bland–Altman plot? Review and contribution based on tolerance intervals and correlated‐errors‐in‐variables models. Statistics in mMdicine, 35(14), 2328-2358.

Francq, B. G., Lin, D., & Hoyer, W. (2019). Confidence, prediction, and tolerance in linear mixed models. Statistics in Medicine, 38(30), 5603-5622.

Francq, B. G., Berger, M., & Boachie, C. (2020). To tolerate or to agree: A tutorial on tolerance intervals in method comparison studies with BivRegBLS R Package. Statistics in Medicine, 39(28), 4334-4349.
}
