% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{PEM}
\alias{PEM}
\title{Percentage exceeding the median}
\usage{
PEM(A_data, B_data, condition, outcome, baseline_phase = unique(condition)[1],
  improvement = "increase")
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}
}
\value{
Numeric value
}
\description{
Calculates the percentage exceeding the median (PEM) index (Ma, 
  2006).
}
\details{
For an outcome where increase is desirable, PEM is calculated as the
  proportion of observations in the B phase that exceed the median 
  observation from the A phase. For an outcome where decrease is desirable, 
  PEM is calculated as the proportion of observations in the B phase that are
  less than the median observation from the A phase. Ties are counted with a
  weight of 0.5. The range of PEM is [0,1].
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
PEM(A_data = A, B_data = B)

}
\references{
Ma, H.-H. (2006). An alternative method for quantitative 
  synthesis of single-subject researches: Percentage of data points exceeding
  the median. \emph{Behavior Modification, 30}(5), 598--617. 
  doi:\href{http://dx.doi.org/10.1177/0145445504272974}{10.1177/0145445504272974}
}
