% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Calculate.R
\name{Celltype_Calculate}
\alias{Celltype_Calculate}
\title{Uses "marker_list" to calculate probability, prediction results, AUC and generate heatmap for cell annotation}
\usage{
Celltype_Calculate(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  min_expression = 0.1,
  specificity_weight = 3,
  threshold = 0.8,
  compute_AUC = TRUE,
  plot_AUC = TRUE,
  AUC_correction = TRUE,
  colour_low = "navy",
  colour_high = "firebrick3"
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{A list of cells and corresponding gene controls, the name of
the list is cell type, and the first column of the list corresponds to markers.
Lists can be generated using functions such as "Markers_filter_Cellmarker2 ()",
"Markers_filter_PanglaoDB ()", "read_excel_markers ()", "read_seurat_markers ()", etc.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
'seurat_clusters'".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = 'RNA'".}

\item{min_expression}{The min_expression parameter defines a threshold value to
determine whether a cell's expression of a feature is considered "expressed"
or not. It is used to filter out low-expression cells that may contribute
noise to the analysis. Default parameters use "min_expression = 0.1".}

\item{specificity_weight}{The specificity_weight parameter controls how much the
expression variability (standard deviation) of a feature within a cluster
contributes to its "specificity score." It amplifies or suppresses the impact
of variability in the final score calculation.Default parameters use
"specificity_weight = 3".}

\item{threshold}{This parameter refers to the normalized similarity between the
"alternative cell type" and the "predicted cell type" in the returned results.
(the default parameter is 0.8)}

\item{compute_AUC}{Logical indicating whether to calculate AUC values for predicted
cell types. AUC measures how well the marker genes distinguish the cluster from
others. When TRUE, adds an AUC column to the prediction results. (default: TRUE)}

\item{plot_AUC}{The logic indicates whether to draw an AUC curve for the predicted cell
type. When TRUE, add an AUC_plot to result. (default: TRUE)}

\item{AUC_correction}{Logical value controlling AUC-based correction. (default = TRUE)
When set to TRUE:
1.Computes AUC values for candidate cell types. (probability > threshold)
2.Selects the cell type with the highest AUC as the final predicted type.
3.Records the selected type's AUC value in the "AUC" column.}

\item{colour_low}{Color for lowest probability level in Heatmap visualization of
probability matrix. (default = "navy")}

\item{colour_high}{Color for highest probability level Heatmap visualization of
probability matrix. (default = "firebrick3")}
}
\value{
A list containing:
\itemize{
\item Expression_list: List of expression matrices for each cell type
\item Proportion_list: List of proportion of expression for each cell type
\item Expression_scores_matrix: Matrix of expression scores
\item Probability_matrix: Matrix of normalized probabilities
\item Prediction_results: Data frame with cluster annotations including:
\itemize{
\item cluster_col: Cluster identifier
\item Predicted_cell_type: Primary predicted cell type
\item AUC: Area Under the Curve value (when compute_AUC = TRUE)
\item Alternative_cell_types: Semi-colon separated alternative cell types
}
\item Heatmap_plot: Heatmap visualization of probability matrix
\item AUC_plot: AUC visualization of Predicted cell type
}
}
\description{
Uses "marker_list" to calculate probability, prediction results, AUC and generate heatmap for cell annotation
}
\examples{
\dontrun{
SlimR_anno_result <- Celltype_Calculate(seurat_obj = sce,
    gene_list = Markers_list,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    min_expression = 0.1,
    specificity_weight = 3,
    threshold = 0.8,
    compute_AUC = TRUE,
    plot_AUC = TRUE,
    AUC_correction = TRUE,
    colour_low = "navy",
    colour_high = "firebrick3"
    )
    }

}
\seealso{
Other Section_3_Automated_Annotation: 
\code{\link{Celltype_Annotation}()},
\code{\link{Celltype_Verification}()},
\code{\link{Parameter_Calculate}()}
}
\concept{Section_3_Automated_Annotation}
