% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_features_30min.R
\name{calc_features30_consumption}
\alias{calc_features30_consumption}
\title{Calculates features from 30-min smart meter data}
\usage{
calc_features30_consumption(
  B,
  rowname = NULL,
  featsCoarserGranularity = FALSE,
  replace_NA_with_defaults = TRUE
)
}
\arguments{
\item{B}{a vector with length 2*24*7 = 336 measurements in one day in seven days a week}

\item{rowname}{the row name of the resulting feature vector}

\item{featsCoarserGranularity}{are the features of finer granularity levels also to be calculated (TRUE/FALSE)}

\item{replace_NA_with_defaults}{replaces missing (NA) or infinite values that may appear during calculation
with default values}
}
\value{
a data.frame with the calculated features as columns and a specified
   rowname, if given
}
\description{
Calculates features from 30-min smart meter data
}
\examples{
# Create a random time series of 30-minute smart meter data (336 measurements per week)
smd <- runif(n=336, min=0, max=2)
# Calculate the smart meter data features
calc_features30_consumption(smd)

}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \url{https://doi.org/10.20378/irbo-54833}

Hopf, K., Sodenkamp, M., Kozlovskiy, I., & Staake, T. (2014).
    Feature extraction and filtering for household classification based on
    smart electricity meter data. Computer Science-Research and Development,
    (31) 3, 141–148. \url{https://doi.org/10.1007/s00450-014-0294-4}

Hopf, K., Sodenkamp, M., & Staake, T. (2018). Enhancing energy
    efficiency in the residential sector with smart meter data analytics.
    Electronic Markets, 28(4). \url{https://doi.org/10.1007/s12525-018-0290-9}

Beckel, C., Sadamori, L., Staake, T., & Santini, S. (2014).
    Revealing household characteristics from smart meter data. Energy, 78,
    397–410. \url{https://doi.org/10.1016/j.energy.2014.10.025}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
