% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_features_daily_nt.R
\name{calc_featuresnt_consumption}
\alias{calc_featuresnt_consumption}
\title{Calculates consumption features from daily (HT / NT) smart meter data}
\usage{
calc_featuresnt_consumption(
  B,
  rowname = NULL,
  featsCoarserGranularity = FALSE,
  replace_NA_with_defaults = TRUE
)
}
\arguments{
\item{B}{a vector with length 2*24*7 = 336 measurements in one day in seven days a week}

\item{rowname}{the row name of the resulting feature vector}

\item{featsCoarserGranularity}{are the features of finer granularity levels also to be calculated (TRUE/FALSE)}

\item{replace_NA_with_defaults}{an optional boolean argument specifying if missing values will be replaced with standard values (i.e., zero values)}
}
\description{
The division in HT / NT is done from the input smart meter data
}
\details{
HT consumption is during the time 07:00-22:00
}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \url{https://doi.org/10.20378/irbo-54833}

Hopf, K., Sodenkamp, M., Kozlovskiy, I., & Staake, T. (2014).
    Feature extraction and filtering for household classification based on
    smart electricity meter data. Computer Science-Research and Development,
    (31) 3, 141–148. \url{https://doi.org/10.1007/s00450-014-0294-4}

Hopf, K., Sodenkamp, M., & Staake, T. (2018). Enhancing energy
    efficiency in the residential sector with smart meter data analytics.
    Electronic Markets, 28(4). \url{https://doi.org/10.1007/s12525-018-0290-9}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
