% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmartSVA.R
\name{smartsva}
\alias{smartsva}
\title{Fast and efficient surrogate variable analysis.}
\usage{
smartsva(dat, mod, mod0 = NULL, n.sv, B = 100, alpha = 0.25,
  epsilon = 0.001, VERBOSE = F)
}
\arguments{
\item{dat}{the measurement matrix, where rows are features and columns are samples.}

\item{mod}{the model matrix being used to fit the data.}

\item{mod0}{the null model matrix.}

\item{n.sv}{the number of surrogate variables to estimate. The use of random matrix theory is recommended to estimate n.sv. See the example for more details.}

\item{B}{the maximum iteration number.}

\item{alpha}{determines the initial point for optimization which affects the convergence rate.}

\item{epsilon}{the convergence threshold. The Spearman's correlation between posterior probabilities of consecutive iterations of the algorithm is compared to epsilon. Empirical evaluation on several data sets revealed epsilon=0.005 gives very reasonable results. However, we suggest epsilon=1e-3 as a conservative threshold.}

\item{VERBOSE}{a logical variable. If TRUE, prints some details about iterative progress of the algorithm.}
}
\value{
Returns a list containing the surrogate variables and some meta data about the convergence criterion.
}
\description{
Performs a significantly more efficient surrogate variable analysis.
}
\examples{
## Methylation M values (CpG by Sample)
Y <- matrix(rnorm(20*1000), 1000, 20)
df <- data.frame(pred=gl(2, 10))

## Determine the number of SVs
Y.r <- t(resid(lm(t(Y) ~ pred, data=df)))
## Add one to compensate potential loss of 1 degree of freedom
##  in confounded scenarios
n.sv <- EstDimRMT(Y.r, FALSE)$dim + 1
mod <- model.matrix( ~ pred, df)
sv.obj <- smartsva(Y, mod, mod0=NULL, n.sv=n.sv)

}

