% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothT.R
\name{LSE}
\alias{LSE}
\title{The least squares estimation for nonparametric tensor estimation with unknown permutation.}
\usage{
LSE(A, kvec, sym = FALSE, mode = 3)
}
\arguments{
\item{A}{A given noisy data tensor.}

\item{kvec}{A vector of the number of groups for each mode.}

\item{sym}{Boolean variables representing symmetricity of the signal tensor.  Non-symmetric tensor (\code{sym = FALSE}) is default.}

\item{mode}{An integer from 1 to 3 representing a type of methods for estimating the clustering functions. Higher-order spectral clustering method is default. \cr\code{mode = 1}: k-means algorithm applied on unfolded matrices. \cr\code{mode = 2}: k-means algorithm for community detection in stocahstic block model (only availble on binary observation). \cr\code{mode = 3}: higher-order spectral clustering algorithm.}
}
\value{
An estimated permuted signal tensor based on the least squares estimation.
}
\description{
Estimate a permuted signal tensor from a noisy data tensor based on  the least squares estimation with constant block approximation.
}
\examples{

# Generate the noisy observation from smooth tensor and permutation
d = 20
sim1 = simulation(d, mode = 1)
signal_T = sim1$signal
observe_T = sim1$observe
permutation = sim1$permutation
psignal_T = signal_T[permutation,permutation,permutation]

# Estimate permuted signal tensor
kvec = c(10,10,10)
hatpTheta = LSE(observe_T,kvec,sym = TRUE)

# Calculate MSE
mean((hatpTheta-psignal_T)^2)

}
\references{
C. Gao, Y. Lu, and H. H. Zhou. Rate-optimal graphon estimation. The Annals of Statistics, 2015. \cr  K. Balasubramanian. Nonparametric modeling of higher-order interactions via hypergraphons. Journal of Machine Learning Research, 2021. \cr R. Han, Y. Luo, M. Wang, and A. R. Zhang. Exact clustering in tensor block model: Statistical optimality and computational limit. arXiv:2012.09996, 2020.
}
