% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smr_fun.R
\name{smr}
\alias{smr}
\title{Standardized mortality ratios and confidence intervals}
\usage{
smr(data, health, population, age, compare, sets, age_group = NULL, CI = 95)
}
\arguments{
\item{data}{Name of data set.}

\item{health}{Health outcome of interest.}

\item{population}{Population counts. Should correspond to data provided in \code{health}.}

\item{age}{Variable that defines 5-year age groups, should be ordered and numeric, such as 1 through 18.
If the age group coding starts with 0 it will be assumed that age groups 0 and 1-4 are separate.
If the age group starts with 1, it will be assumed that the first age group is 0-4 (ages 0 and 1-4 are combined).}

\item{compare}{Categorical variable that splits the data into groups that are to be compared, such as ethnicity.}

\item{sets}{Groups that are to be compared (values taken by \code{compare}). The group listed first will be the
reference category. Must take at least two values.}

\item{age_group}{The age groups the standardized rates should be calculated for. By default the function calculates
results for the following age groups: 0-14, 15-29, 30-44, 45-59, 60-74, 75+, 0-64 and all ages.
User supplied age groups should be provided using the standard population groups as cut-offs, e.g. use
\code{age_group=c("20-29", "30-39")} and not \code{c("19-30", "31-41")}. Open ended age groups can be supplied by giving
a single age, e.g. "45" means 45 and above. Overlapping age groups, such as \code{c("20-29", "25-34")}, are not supported.
Results for ages 0-64 and all ages will always be provided.}

\item{CI}{Confidence intervals, 95 by default but can be set to any number between 0 and 100.
For calculation method see user guide.}
}
\value{
A data frame of standardized mortality ratios (SMR) and CIs.
}
\description{
The function \code{smr} calculates standardized mortality ratios (SMR) and confidence intervals for SMR.
}
\examples{
d <- health_data

# Asian population compared to Scottish (reference)
smr(d, bad, pop, age, ethnicity, sets = c("Scot", "asian"))

# Asian, White British and Irish population compared to Scottish (reference)
smr(d, bad, pop, age, ethnicity, sets = c("Scot", "asian", "WB", "Irish"),
  age_group = c("15-29", "30-44"), CI = 99)

}
