% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependence_probit.R
\name{partial_dependence_probit}
\alias{partial_dependence_probit}
\title{Partial Dependence Function for SoftBART Probit Regression}
\usage{
partial_dependence_probit(fit, test_data, var_str, grid)
}
\arguments{
\item{fit}{A fitted model of type \code{softbart_probit}.}

\item{test_data}{A data set used to form the baseline distribution of covariates for the partial dependence function.}

\item{var_str}{A string giving the variable name of the predictor to compute the partial dependence function for.}

\item{grid}{The values of the predictor to compute the partial dependence function at.}
}
\value{
Returns a list with the following components:
\itemize{
  \item \code{pred_df}: a data frame containing columns for a MCMC iteration ID (\code{sample}), the value on the grid, and the partial dependence function value.
  \item \code{p}: a matrix containing the same information as \code{pred_df}, with the rows corresponding to iterations and columns corresponding to grid values.
  \item \code{grid}: the grid used as input.
}
}
\description{
Computes the partial dependence function for a given covariate at a given set of covariate values for the probit model.
}
