% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kfilm.R
\name{Kfilm}
\alias{Kfilm}
\title{Relative film conductivity}
\usage{
Kfilm(suc, par.shp, modality = "uni", suc.negativ = TRUE)
}
\arguments{
\item{suc}{Suction/pressure heads. Negative if suc.negativ = TRUE}

\item{par.shp}{named parameter in list or vector}

\item{modality}{pore size distribution ('uni' or 'bi')}

\item{suc.negativ}{set TRUE if suction/pressure heads are negative and FALSE if positive}
}
\description{
Relative film conductivity described by Peters (2013).
}
\details{
\describe{\item{par.shp:}{
ths [-]: saturated water content \cr
thr [-]: residual water content \cr
alfa [1/L]: van Genuchten shape parameter \cr
n [-]: van Genuchten shape parameter \cr
h0 [L]: suction at water content of 0 (i.e. oven dryness) (h0 = 10^6.8 if missing, corresponding to oven dryness at 105°C (Schneider and Goss, 2012))\cr
a: slope at the log scale (a = -1.5 if missing as suggested by Tokunaga (2009) and Peters (2013))}
\item{}{additional for bimodal (modality == 'bi'): \cr
alfa2 [1/L]: van Genuchten parameter alfa for second pore space distribution \cr
n2 [-]: van Genuchten parameter n for second pore space distribution}}
}
\references{
Peters, A. (2013). Simple consistent models for water retention and hydraulic conductivity in the complete moisture range. Water Resour. Res. 49, 6765–6780. physics-a review. Vadose Zone J. http://dx.doi.org/10.2136/vzj2012.0163.

Tokunaga, T. K. (2009). Hydraulic properties of adsorbed water films in unsaturated porous media. Water resources research, 45(6).

Schneider, M., & Goss, K. U. (2012). Prediction of the water sorption isotherm in air dry soils. Geoderma, 170, 64-69.
}
\seealso{
\code{\link{Ku}}
}
