% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlModel.R
\name{getC,NlModel-method}
\alias{getC,NlModel-method}
\title{Pool Contents for all times}
\usage{
\S4method{getC}{NlModel}(object, as.closures = FALSE)
}
\arguments{
\item{object}{object of class:\code{NlModel}, no manual documentation}

\item{as.closures}{If \code{TRUE} will return the result as a list of
approximating functions of time indexed by the pool number.}
}
\value{
If \code{as.closures} is \code{FALSE} (the default) the return value is a matrix with as many columns as there are pools 
and as many rows as there are entries in the \code{times} 
argument the model has been built with.
}
\description{
Pool Contents for all times

The solution of the initial value problem (IVP) for the pool contents.
Since the first models in SoilR had only Carbon pools 
the function name \code{getC} could be interpreted as 
referring to the C content. If the model includes other 
element cycles e.g. N or P this interpretation is no longer 
valid. In this case the C in 'getC' stands for 'content' 
since the function will always return the solution for 
all pools, regardless of the chemical element the author of 
the model associated them with.
}
