#-------------------------------------------------
IVP_maker <- function(
  in_fluxes,
	internal_fluxes,
	out_fluxes,
	time_symbol,
	startValues
){
  accumulated_fluxes_startvector <- rep(0,length(in_fluxes)+length(internal_fluxes)+length(out_fluxes))
  names(accumulated_fluxes_startvector) <-c(
    unlist(
      lapply(
        in_fluxes,
        function(flux){
          paste0('accumulated_influx','.',flux@destinationName)
        }
      )
    )
    ,
    unlist(
      lapply(
        internal_fluxes,
        function(flux){
          paste0(
            'accumulated_internal_flux',
            '.',
            src_to_dest_string(flux@sourceName,flux@destinationName)
          )
        }
      )
    )
    ,
    unlist(
      lapply(
        out_fluxes,
        function(flux){
          paste0('accumulated_outflux','.',flux@sourceName)
        }
      )
    )
  )
  accumulated_fluxes_startvector
  ydot=ydot_maker(
    in_fluxes,
		internal_fluxes,
		out_fluxes,
		time_symbol,
		names=names(startValues)
  )
  list(ydot=ydot,startValues=c(startValues,accumulated_fluxes_startvector))
}
