% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{Model}
\alias{Model}
\title{Constructor for class \linkS4class{Model}}
\usage{
Model(
  t,
  A,
  ivList,
  inputFluxes,
  solverfunc = deSolve.lsoda.wrapper,
  pass = FALSE
)
}
\arguments{
\item{t}{A vector containing the points in time where the solution is
sought.}

\item{A}{something that can be converted by \link{GeneralDecompOp} to any of
the available subclasses of \code{\linkS4class{DecompOp}}.}

\item{ivList}{A numeric vector containing the initial amount of carbon for
the n pools. The length of this vector is equal to the number of pools. This
is checked by an internal function.}

\item{inputFluxes}{something that can be converted by \link{InFluxes}
to any of the available subclasses of \linkS4class{InFluxes}.}

\item{solverfunc}{The function used to actually solve the ODE system. The
default is \code{\link{deSolve.lsoda.wrapper}} but you can also provide your
own function that the same interface.}

\item{pass}{Forces the constructor to create the model even if it does not
pass internal sanity checks}
}
\value{
An object of class \linkS4class{Model} that can be queried by many
methods to be found there.
}
\description{
This function creates an object of class \linkS4class{Model}, The arguments
can be given in different form as long as they can be converted to the
necessary internal building blocks.  (See the links)
}
\details{
This function \code{Model} wraps the internal constructor of class
\linkS4class{Model}. The internal constructor requires the argument \code{A}
to be of class \linkS4class{DecompOp} and argument \code{inputFluxes} to be
of class \linkS4class{InFluxes}. Before calling the internal constructor
\code{Model} calls \link{GeneralDecompOp} on its argument \code{A} and
\link{InFluxes} on its argument \code{inputFluxes} to convert them into
the required classes. Both are generic functions. Follow the links to see
for which kind of inputs conversion methods are available. The attempted
conversion allows great flexibility with respect to arguments and
independence from the actual implementation. However if your code uses the
wrong argument the error will most likely occur in the delegate functions.
If this happens inspect the error message (or use \code{traceback()}) to see
which function was called and try to call the constructor of the desired
subclass explicitly with your arguments.  The subclasses are linked in the
class documentation \linkS4class{DecompOp} or \linkS4class{InFluxes}
respectively.

Note also that this function checks its arguments quite elaborately and
tries to detect accidental unreasonable combinations, especially concerning
two kinds of errors. 
\enumerate{ 
\item unintended extrapolation of time series data 
\item violations of mass balance by the DecompOp argument. 
}

SoilR has a lot of unit tests which are installed with the package and are
sometimes instructive as examples.  To see example scenarios for parameter
check look at:
\Sexpr{system.file('tests','runit.correctness_of_Model.R',package='SoilR')}
}
\examples{

# vim:set ff=unix expandtab ts=2 sw=2:
test.all.possible.Model.arguments <- function(){
  # This example shows different kinds of arguments to the function Model.
  # The model objects we will build will share some common features.
  #  - two pools 
  #  - initial values 

  iv<-  c(5,6)
  times <- seq(1,10,by=0.1)

  # The other parameters A and inputFluxes will be different
  # The function Model will transform these arguments 
  # into objects of the classes required by the internal constructor.
  # This leads to a number of possible argument types. 
  # We demonstrate some of the possibilities here.
  # Let us first look at the choeices for argument 'A'.
  
  #) 
  possibleAs  <- example.2DGeneralDecompOpArgs()
  
  # Since "Model" will call "InFluxes" on its "inputFluxes" 
  # argument there are again different choices
  # we have included a function in SoilR that produces 2D examples
  
  possibleInfluxes <- example.2DInFluxes.Args()
 print(possibleInfluxes$I.vec)
  # We can build a lot of  models from the possible combinations
  # for instance   
  #m1 <- Model(
  #        t=times,
  #        A=matrix(nrow=2,byrow=TRUE,c(-0.1,0,0,-0.2)),
  #        ivList=iv,
  #        inputFluxes=possibleInfluxes$I.vec) 
  ## We now produce all combinations of As and InputFluxes
  combinations <- listProduct(possibleAs,possibleInfluxes)
  print(length(combinations))
  # and a Model for each
  models <- lapply(
              combinations,
              function(combi){
                #Model(t=times,A=combi$A,ivList=iv,inputFluxes=combi$I)
                Model(t=times,A=combi[[1]],ivList=iv,inputFluxes=combi[[2]])
              }
            )
  ## lets check that we can compute something# 
  lapply(models,getC)
}
}
\seealso{
This function is called by many of the \link{predefinedModels}. \cr
Package functions called in the examples:\cr
\code{\link{example.2DInFluxes.Args}},\cr
\code{\link{example.2DGeneralDecompOpArgs}},\cr
}
