% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explainST.R
\name{explainST}
\alias{explainST}
\title{Explain a taxon name using formative elements}
\usage{
explainST(x, format = c("text", "html"), viewer = TRUE)
}
\arguments{
\item{x}{a Subgroup, Great Group, Suborder or Order-level taxonomic name; matching is exact and case-insensitive}

\item{format}{output format: 'text' | 'html'}

\item{viewer}{show \code{format = 'html'} output in browser? default: \code{TRUE}}
}
\value{
a block of text, suitable for display in fixed-width font
}
\description{
Explain a taxon name using formative elements
}
\examples{

cat(explainST("ids"), "\n\n")              #  -ids (order suffix) 
cat(explainST("aridisols"), "\n\n")        # Aridisols (order name)
cat(explainST("argids"), "\n\n")           # Arg- (suborder) 
cat(explainST("haplargids"), "\n\n")       # Hap- (great group)
cat(explainST("typic haplargids"), "\n\n") # Typic (subgroup)

}
