% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soj_1x_original.R
\name{soj_1x_original}
\alias{soj_1x_original}
\title{Invoke the original uni-axial Sojourn method}
\usage{
soj_1x_original(
  counts,
  perc.cut = 0.05,
  perc.cut.2 = 0.12,
  perc.cut.3 = 0.55,
  too.short = 10,
  sit.cut = 90,
  long.soj = 120
)
}
\arguments{
\item{counts}{numeric vector of vertical axis counts}

\item{perc.cut}{decision tree threshold 1}

\item{perc.cut.2}{decision tree threshold 2}

\item{perc.cut.3}{decision tree threshold 3}

\item{too.short}{minimum length of one Sojourn}

\item{sit.cut}{cut-point for determining sitting}

\item{long.soj}{maximum length of one Sojourn}
}
\value{
a data frame of processed data
}
\description{
Calls the uni-axial Sojourn method from \href{https://pubmed.ncbi.nlm.nih.gov/23860415/}{Lyden et al. (2014)}.
}
\examples{
data(example_data, package = "Sojourn")
if (isTRUE(requireNamespace("Sojourn.Data"))) {
  results_1x <- soj_1x_original(example_data$axis1)
  utils::head(results_1x)
}
}
