% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIP_Soj_3x.R
\name{sojourn_3x_SIP}
\alias{sojourn_3x_SIP}
\title{Triaxial Sojourn method for the \href{https://pubmed.ncbi.nlm.nih.gov/27015380/}{SIP method}}
\usage{
sojourn_3x_SIP(ag, short = 30)
}
\arguments{
\item{ag}{combined ActiGraph and activPAL data on which to identify
transitions and make predictions}

\item{short}{the minimum duration of a qualifying Sojourn}
}
\value{
A data frame of processed data using the
  \href{https://pubmed.ncbi.nlm.nih.gov/27015380/}{SIP method}
}
\description{
Triaxial Sojourn method for the \href{https://pubmed.ncbi.nlm.nih.gov/27015380/}{SIP method}
}
\examples{
data(SIP_ag, package = "Sojourn")
data(SIP_ap, package = "Sojourn")
data <- Sojourn::enhance_actigraph(SIP_ag, SIP_ap)
if (isTRUE(requireNamespace("Sojourn.Data"))) {
  utils::head(sojourn_3x_SIP(data))
}
}
