% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Col.Meta-doc.R
\name{Col.Meta}
\alias{Col.Meta}
\alias{colmeta}
\alias{annotations}
\alias{rowmeta}
\title{Analyte Annotations, Col.Meta, and Row Info}
\description{
In a standard SomaLogic ADAT, the section of information that
sits directly above the measurement data (RFU data matrix) is
the column meta data (\code{Col.Meta}), which contains detailed information
and annotations about the analytes, \code{\link[=SeqId]{SeqId()}}s, and their targets.
See section below for further information about available
fields and their descriptions. Use \code{\link[=getAnalyteInfo]{getAnalyteInfo()}} to
obtain an object containing this information for programmatic analyses,
and use \code{\link[=getMeta]{getMeta()}} to obtain the column names representing the
row-specific meta data about the samples (see section below).
}
\section{Col Meta (Analyte Annotations)}{

Information describing the \emph{analytes} is found to the above
the data matrix in a standard SomaLogic ADAT. This information may
consist of the any or all of the following:\tabular{lll}{
   \strong{Field} \tab \strong{Description} \tab \strong{Example} \cr
   SeqId \tab SomaLogic sequence identifier \tab 2182-54_1 \cr
   SeqidVersion \tab Version of SOMAmer sequence \tab 2 \cr
   SomaId \tab Target identifier, of the form SLnnnnnn (8 characters in length) \tab SL000318 \cr
   TargetFullName \tab Target name curated for consistency with UniProt name \tab Complement C4b \cr
   Target \tab SomaLogic Target Name \tab C4b \cr
   UniProt \tab UniProt identifier(s) \tab P0C0L4  P0C0L5 \cr
   EntrezGeneID \tab Entrez Gene Identifier(s) \tab 720 721 \cr
   EntrezGeneSymbol \tab Entrez Gene Symbol names \tab C4A C4B \cr
   Organism \tab Protein Source Organism \tab Human \cr
   Units \tab Relative Fluorescence Units \tab RFU \cr
   Type \tab SOMAmer target type \tab Protein \cr
   Dilution \tab Dilution mix assignment \tab 0.01\% \cr
   PlateScale_Reference \tab PlateScale reference value \tab 1378.85 \cr
   CalReference \tab Calibration sample reference value \tab 1378.85 \cr
   medNormRef_ReferenceRFU \tab Median normalization reference value \tab 490.342 \cr
   Cal_V4_\verb{<YY>_<SSS>_<PPP>} \tab Calibration scale factor (for given Year_Study_Plate) \tab 0.64 \cr
   ColCheck \tab QC acceptance criteria across all plates/sets \tab PASS \cr
   QcReference_\verb{<LLLLL>} \tab QC sample reference value (for given QC lot) \tab PASS \cr
   CalQcRatio_V4_\verb{<YY>_<SSS>_<PPP>} \tab Post calibration median QC ratio to reference (for given Year_Study_Plate) \tab 1.04 \cr
}
}

\section{Row Meta (Sample Annotations)}{

Information describing the \emph{samples} is typically found to the left of
the data matrix in a standard SomaLogic ADAT. This information may
consist of clinical information provided by the client, or run-specific
diagnostic information included for assay quality control. Below are
some examples of what may be present in this section:\tabular{lll}{
   \strong{Field} \tab \strong{Description} \tab \strong{Examples} \cr
   PlateId \tab Plate identifier \tab V4-18-004_001, V4-18-004_002 \cr
   ScannerID \tab Scanner used to analyze slide \tab SG12064173, SG14374437 \cr
   PlatePosition \tab Location on 96 well plate (A1-H12) \tab A1, H12 \cr
   SlideId \tab Agilent slide barcode \tab 2.58E+11 \cr
   Subarray \tab Agilent subarray (1 – 8) \tab 1,8 \cr
   SampleId \tab 1st form is Subject Identifier, 2nd form (calibrators, buffers) \tab 2031 \cr
   SampleType \tab 1st form for clinical samples (Sample), 2nd form as above \tab Sample, QC, Calibrator, Buffer \cr
   PercentDilution \tab Highest concentration the SOMAmer dilution groups \tab 20 \cr
   SampleMatrix \tab Sample matrix \tab Plasma-PPT \cr
   Barcode \tab 1D Barcode of aliquot \tab S622225 \cr
   Barcode2d \tab 2D Barcode of aliquot \tab 1.91E+08 \cr
   SampleNotes \tab Assay team sample observation \tab Cloudy, Low sample volume, Reddish \cr
   SampleDescription \tab Supplemental sample information \tab Plasma QC 1 \cr
   AssayNotes \tab Assay team run observation \tab Beads aspirated, Leak/Hole, Smear \cr
   TimePoint \tab Sample time point \tab Baseline \cr
   ExtIdentifier \tab Primary key for Subarray \tab EXID40000000032037 \cr
   SsfExtId \tab Primary key for sample \tab EID102733 \cr
   SampleGroup \tab Sample group \tab A, B \cr
   SiteId \tab Collection site \tab SomaLogic, Covance \cr
   TubeUniqueID \tab Unique tube identifier \tab 1.12E+11 \cr
   CLI \tab Cohort definition identifier \tab CLI6006F001 \cr
   HybControlNormScale \tab Hybridization control scale factor \tab 0.948304 \cr
   RowCheck \tab Normalization acceptance criteria for all row scale factors \tab PASS, FLAG \cr
   NormScale_0_5 \tab Median signal normalization scale factor (0.5\% mix) \tab 1.02718 \cr
   NormScale_0_005 \tab Median signal normalization scale factor (0.005\% mix) \tab 1.119754 \cr
   NormScale_20 \tab Median signal normalization scale factor (20\% mix) \tab 0.996148 \cr
}
}

\examples{
# Annotations/Col.Meta
tbl <- getAnalyteInfo(example_data)
tbl

# Row/sample Meta
r_m <- getMeta(example_data)
head(r_m)

# Normalization Scale Factors
grep("NormScale", r_m, value = TRUE)

# adat subset
example_data[1:3, head(r_m)]
}
