% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseHeader.R
\name{parseHeader}
\alias{parseHeader}
\title{SomaLogic ADAT parser}
\usage{
parseHeader(file)
}
\arguments{
\item{file}{Character. The elaborated path and file name of the
\verb{*.adat} file to be loaded into an R workspace environment.}
}
\value{
A list of relevant file information required by \code{\link[=read_adat]{read_adat()}}
in order to complete loading the ADAT file, including:
\item{Header.Meta}{list of notes and other information about the adat}
\item{Col.Meta}{list of vectors that contain the column meta
data about individual analytes, includes information about the target
name and calibration and QC ratios}
\item{file_specs}{list of values of the file parsing specifications}
\item{row_meta}{character vector of the clinical variables; assay
information that is included in the adat output along with the RFU data}
}
\description{
Parses the header section of an ADAT file.
}
\examples{
f <- system.file("extdata", "example_data10.adat",
                 package = "SomaDataIO", mustWork = TRUE)
header <- parseHeader(f)
header
}
\seealso{
Other IO: 
\code{\link{loadAdatsAsList}()},
\code{\link{read_adat}()},
\code{\link{soma_adat}},
\code{\link{write_adat}()}
}
\author{
Stu Field
}
\concept{IO}
