% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupGenerics.R
\name{groupGenerics}
\alias{groupGenerics}
\alias{Math.soma_adat}
\alias{antilog}
\alias{Ops.soma_adat}
\alias{Summary.soma_adat}
\alias{==.soma_adat}
\title{Group Generics for \code{soma_adat} Class Objects}
\usage{
\method{Math}{soma_adat}(x, ...)

antilog(x, base = 10)

\method{Ops}{soma_adat}(e1, e2 = NULL)

\method{Summary}{soma_adat}(..., na.rm = FALSE)

\method{==}{soma_adat}(e1, e2)
}
\arguments{
\item{x}{The \code{soma_adat} class object to perform the transformation.}

\item{...}{Additional arguments passed to the various group generics
as appropriate.}

\item{base}{A positive or complex number: the base with respect to
which logarithms are computed.}

\item{e1, e2}{Objects.}

\item{na.rm}{Logical. Should missing values be removed?}
}
\value{
A \code{soma_adat} object with the same dimensions of the input
object with the feature columns transformed by the specified generic.
}
\description{
S3 group generic methods to apply group specific prototype functions
to the RFU data \strong{only} of \code{soma_adat} objects.
The clinical meta data are \emph{not} transformed and remain unmodified in
the returned object (\code{\link[=Math]{Math()}} and \code{\link[=Ops]{Ops()}}) or are ignored for the
\code{\link[=Summary]{Summary()}} group. See \code{\link[=groupGeneric]{groupGeneric()}}.
}
\section{Functions}{
\itemize{
\item \code{antilog()}: performs the inverse or anti-log transform for a numeric vector of
\code{soma_adat} object. \strong{note:} default is \code{base = 10}, which differs from
the \code{\link[=log]{log()}} default base \emph{e}.

\item \code{Ops(soma_adat)}: performs binary mathematical operations on class \code{soma_adat}. See \code{\link[=Ops]{Ops()}}.

\item \code{Summary(soma_adat)}: performs summary calculations on class \code{soma_adat}. See \code{\link[=Summary]{Summary()}}.

\item \code{ == }: compares left- and right-hand sides of the operator \emph{unless} the RHS
is also a \code{soma_adat}, in which case \code{\link[=diffAdats]{diffAdats()}} is invoked.

}}
\section{Math}{

Group members:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>  [1] "abs"      "acos"     "acosh"    "asin"     "asinh"    "atan"    
#>  [7] "atanh"    "ceiling"  "cos"      "cosh"     "cospi"    "cummax"  
#> [13] "cummin"   "cumprod"  "cumsum"   "digamma"  "exp"      "expm1"   
#> [19] "floor"    "gamma"    "lgamma"   "log"      "log10"    "log1p"   
#> [25] "log2"     "sign"     "sin"      "sinh"     "sinpi"    "sqrt"    
#> [31] "tan"      "tanh"     "tanpi"    "trigamma" "trunc"
}\if{html}{\out{</div>}}

Commonly used generics of this group include:
\itemize{
\item \code{log()}, \code{log10()}, \code{log2()}, \code{antilog()},
\code{abs()}, \code{sign()}, \code{floor()}, \code{sqrt()}, \code{exp()}
}
}

\section{Ops}{

Group members:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>  [1] "+"   "-"   "*"   "^"   "\%\%"  "\%/\%" "/"   "=="  ">"   "<"   "!="  "<=" 
#> [13] ">="
}\if{html}{\out{</div>}}

Note that for the \verb{`==`} method if the RHS is also a \code{soma_adat},
\code{\link[=diffAdats]{diffAdats()}} is invoked which compares LHS vs. RHS.
Commonly used generics of this group include:
\itemize{
\item \code{+}, \code{-}, \code{*}, \code{/}, \code{^}, \code{==}, \code{>}, \code{<}
}
}

\section{Summary}{

Group members:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "all"   "any"   "max"   "min"   "prod"  "range" "sum"
}\if{html}{\out{</div>}}

Commonly used generics of this group include:
\itemize{
\item \code{max()}, \code{min()}, \code{range()}, \code{sum()}, \code{any()}
}
}

\examples{
# subset `example_data` for speed
# all SeqIds from 2000 -> 2999
seqs <- grep("^seq\\\\.2[0-9]{3}", names(example_data), value = TRUE)
ex_data_small <- head(example_data[, c(getMeta(example_data), seqs)], 10L)
dim(ex_data_small)

ex_data_small$seq.2991.9

# Math Generics:
# -------------
# log-transformation
a <- log(ex_data_small)
a$seq.2991.9

b <- log10(ex_data_small)
b$seq.2991.9
isTRUE(all.equal(b, log(ex_data_small, base = 10)))

# floor
c <- floor(ex_data_small)
c$seq.2991.9

# square-root
d <- sqrt(ex_data_small)
d$seq.2991.9

# rounding
e <- round(ex_data_small)
e$seq.2991.9

# inverse log
antilog(1:4)

alog <- antilog(b)
all.equal(ex_data_small, alog)    # return `b` -> linear space

# Ops Generics:
# -------------
plus1 <- ex_data_small + 1
times2 <- ex_data_small * 2

sq <- ex_data_small^2
all.equal(sqrt(sq), ex_data_small)

gt100k <- ex_data_small > 100000
gt100k

ex_data_small == ex_data_small   # invokes diffAdats()

# Summary Generics:
# -------------
sum(ex_data_small)

any(ex_data_small < 100)  # low RFU analytes

sum(ex_data_small < 100)  # how many

min(ex_data_small)

min(ex_data_small, 0)

max(ex_data_small)

max(ex_data_small, 1e+7)

range(ex_data_small)
}
\seealso{
\code{\link[=groupGeneric]{groupGeneric()}}, \code{\link[=getGroupMembers]{getGroupMembers()}}, \code{\link[=getGroup]{getGroup()}}
}
\author{
Stu Field
}
