% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spe.R
\name{spe}
\alias{spe}
\title{Empirical Sorted Partial Effects (SPE) and Inference}
\usage{
spe(
  fm,
  data,
  method = c("ols", "logit", "probit", "QR"),
  var_type = c("binary", "continuous", "categorical"),
  var,
  compare,
  subgroup = NULL,
  samp_weight = NULL,
  us = c(1:9)/10,
  alpha = 0.1,
  taus = c(5:95)/100,
  b = 500,
  parallel = FALSE,
  ncores = detectCores(),
  seed = 1,
  bc = TRUE,
  boot_type = c("nonpar", "weighted")
)
}
\arguments{
\item{fm}{Regression formula.}

\item{data}{Data in use.}

\item{method}{Models to be used for estimating partial effects. Four
options: \code{"logit"} (binary response),
\code{"probit"} (binary response), \code{"ols"}
(interactive linear with additive errors), \code{"QR"}
(linear model with non-additive errors). Default is
\code{"ols"}.}

\item{var_type}{The type of parameter in interest. Three options:
\code{"binary"}, \code{"categorical"},
\code{"continuous"}. Default is \code{"binary"}.}

\item{var}{Variable T in interset. Should be a character type.}

\item{compare}{If parameter in interest is categorical, then user needs
to specify which two category to compare with. Should be
a 1 by 2 character vector. For example, if the two levels
to compare with is 1 and 3, then \code{c=("1", "3")},
which will calculate partial effect from 1 to 3. To use
this option, users first need to specify \code{var} as a
factor variable.}

\item{subgroup}{Subgroup in interest. Default is \code{NULL}.
Specifcation should be a logical variable. For example,
suppose data contains indicator variable for women
(female if 1, male if 0). If users are interested in
women SPE, then users should specify \code{subgroup =
data[, "female"] == 1}.}

\item{samp_weight}{Sampling weight of data. Input should be a n by 1 vector,
where n denotes sample size. Default is \code{NULL}.}

\item{us}{Percentile of interest for SPE. Should be a vector of
values between 0 and 1. Default is \code{c(1:9)/10}.}

\item{alpha}{Size for confidence interval. Shoule be between 0 and 1.
Default is 0.1}

\item{taus}{Indexes for quantile regression. Default is
\code{c(5:95)/100}.}

\item{b}{Number of bootstrap draws. Default is set to be 500.}

\item{parallel}{Whether the user wants to use parallel computation.
The default is \code{FALSE} and only 1 CPU will be used.
The other option is \code{TRUE}, and user can specify
the number of CPUs in the \code{ncores} option.}

\item{ncores}{Number of cores for computation. Default is set to be
\code{detectCores()}, which is a function from package
\code{parallel} that detects the number of CPUs on the
current host. For large dataset, parallel computing is
highly recommended since bootstrap is time-consuming.}

\item{seed}{Pseudo-number generation for reproduction. Default is 1.}

\item{bc}{Whether want the estimate to be bias-corrected. Default
is \code{TRUE}. If \code{FALSE} uncorrected estimate and
corresponding confidence bands will be reported.}

\item{boot_type}{Type of bootstrap. Default is \code{"nonpar"}, and the
package implements nonparametric bootstrap. The other
alternative is \code{"weighted"}, and the package
implements weighted bootstrap.}
}
\value{
The output is a list with 4 components: (1) \code{spe} stores spe
estimates, the upper and lower confidence bounds, and standard errors;
(2) \code{ape} stores ape estimates, the upper and lower confidence bounds,
and the standard error; (3) \code{us} stores percentile index as in \
code{spe} command; (4) \code{alpha} stores significance level as in
\code{spe} command.
}
\description{
\code{spe} conducts SPE estimation and inference at user-specifed quantile
index. The bootstrap procedures follows algorithm 2.1 as in Chernozhukov,
Fernandez-Val and Luo (2018). All estimates are bias-corrected and all
confidence bands are monotonized. For graphical results, please use
\code{\link{plot.spe}}.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec + ltv_med +
ltv_high + denpmi + selfemp + single + hischl

test <- spe(fm = fm, data = mortgage, var = "black", method = "logit",
us = c(2:98)/100, b = 50)

}
