% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{testMeanVariance}
\alias{testMeanVariance}
\title{Test the equality of two normal distributions}
\usage{
testMeanVariance(S, S1, S2, n1, n2)
}
\arguments{
\item{S}{estimated covariance matrix for pooled sample}

\item{S1}{estimated covariance matrix in class 1}

\item{S2}{estimated covariance matrix in class 2}

\item{n1}{number of samples in class 1}

\item{n2}{number of samples in class 2}
}
\value{
The function returns a list that contain the test statistic (\code{stat}) and the p-value test obtained of equality, using the asymptotic distribution (\code{alpha}).
}
\description{
The function performs the test of equality of two multivariate normal distrbutions (class1 and class2).
}
\details{
The criterion for testing the equality of two normal distributions is the following:
\deqn{\Lambda_c =  n_1 * log( |S| / |S^1| ) +  n_2 * log( |S| / |S^2| )  }
The asymptotic null distribution of the criterion, when the maximum likelihood estimates of the covariance matrices are used, is Chi square with \eqn{ |\Gamma| * (|\Gamma|+3) / 2} degrees of freedom, where G is the dimension of the underlying distributions.
}
\note{
The asymptotic null distributions holds only when the maximum likelihood estimates of the covariance matrices are supplied.
}
\examples{
if(require(mvtnorm)){

  ## Generate two random samples of size 50 from two multivariate normal distributions
  # sample size
  n<-50
  # true parameters of class 1 and class 2
  param.class1<-simulation$condition1
  param.class2<-simulation$condition2$`5`$`2`
  # simulated dataset
  data.class1<-rmvnorm(n = n,mean =param.class1$mu ,sigma =param.class1$S)
  data.class2<-rmvnorm(n = n,mean =param.class2$mu ,sigma=param.class2$S)
  data<-rbind(data.class1,data.class2)
  classes<-c(rep(1,nrow(data.class1)),rep(2,nrow(data.class2)))

  s<-cov(data)
  s1<-cov(data.class1)
  s2<-cov(data.class2)
  testMeanVariance(S = s,S1 =s1, S2 = s2, n1 = n, n2 = n)

  ## equivalently...
  # estimated parameters: maximum likelihood estimate
  est.param<-parameters(data = data,classes =classes ,shrink = FALSE)
  testMeanVariance(est.param$S,est.param$S1,est.param$S2,est.param$n1,est.param$n2)
}
}
\seealso{
\code{\link[SourceSet]{parameters}}
}
