% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SpaCC}
\alias{SpaCC}
\title{Base function for computing SpaCC solution for single regularization value.}
\usage{
SpaCC(X, w, gamma, nu, verbose, tol, maxiter, Uinit, Vinit, Laminit)
}
\arguments{
\item{X}{A subject (n) by probe (p) data matrix}

\item{w}{A vector weights for adjacent probes. Should have length nprobes -1}

\item{gamma}{A scalar value for the regularization parameter}

\item{nu}{A scalar value for the step size in AMA algorithm}

\item{verbose}{Logical value whether progress should be printed}

\item{tol}{A scalar value for convergence tolerance.}

\item{maxiter}{Maximum number of iterations}

\item{Uinit}{A matrix used for warm starts with U}

\item{Vinit}{A matrix used for warm start with V}

\item{Laminit}{A matrix used for warm starts with Lam}
}
\value{
An RcppArmadillo field object. Has three components, each holds the U,V, and Lam matrix for the current regularization
}
\description{
Base function for computing SpaCC solution for single regularization value.
}

