% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\docType{methods}
\name{versionWarning}
\alias{versionWarning}
\alias{versionWarning,character-method}
\title{Compare module version against SpaDES package version and warn if incompatible}
\usage{
versionWarning(moduleName, moduleVersion)

\S4method{versionWarning}{character}(moduleName, moduleVersion)
}
\arguments{
\item{moduleName}{Character string providing the module name.}

\item{moduleVersion}{The module version as either a character, numeric, or
numeric version (e.g., extracted from module metadata).
Is coerced to \code{numeric_version}.}
}
\value{
Logical (invisibly) indicating whether the module is compatible with
the version of the SpaDES package.
Will also produce a warning if not compatible.
}
\description{
Performs a basic check to ensure the module version is compatible with the
SpaDES package version.
Compatibility is best assured when both versions are equal.
If module version < spades version, there is likely no problem, as SpaDES
should be backwards compatible.
However, if module version > spades version, the user needs to update their
version of SpaDES because module compatibility cannot be assured.
}
\author{
Alex Chubaty
}

