% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\docType{methods}
\name{.convertSpatialToPlotGrob}
\alias{.Plot}
\alias{.Plot,.spadesGrob-method}
\alias{.convertSpatialToPlotGrob}
\alias{.convertSpatialToPlotGrob,spatialObjects,.spadesGrob-method}
\alias{.refreshGrob}
\alias{.refreshGrob,.spadesGrob-method}
\alias{.updateGrobGPTextAxis}
\alias{.updateGrobGPTextAxis,.spadesGrob-method}
\alias{.xyAxes}
\alias{.xyAxes,.spadesGrob,.arrangement-method}
\alias{PlotHelpers}
\title{Internal functions used by Plot}
\usage{
.convertSpatialToPlotGrob(grobToPlot, sGrob, takeFromPlotObj, arr, newArr,
  spadesGrobCounter, subPlots, cols)

\S4method{.convertSpatialToPlotGrob}{spatialObjects,.spadesGrob}(grobToPlot,
  sGrob, takeFromPlotObj, arr, newArr, spadesGrobCounter, subPlots, cols)

.xyAxes(sGrob, arr, whPlotFrame)

\S4method{.xyAxes}{.spadesGrob,.arrangement}(sGrob, arr, whPlotFrame)

.Plot(sGrob, grobToPlot, subPlots, spadesSubPlots, spadesGrobCounter,
  isBaseSubPlot, isNewPlot, isReplot, zMat, wipe, xyAxes, legendText, vps,
  nonPlotArgs)

\S4method{.Plot}{.spadesGrob}(sGrob, grobToPlot, subPlots, spadesSubPlots,
  spadesGrobCounter, isBaseSubPlot, isNewPlot, isReplot, zMat, wipe, xyAxes,
  legendText, vps, nonPlotArgs)

.refreshGrob(sGrob, subPlots, legendRange, grobToPlot, plotArgs, nColumns,
  whPlotObj)

\S4method{.refreshGrob}{.spadesGrob}(sGrob, subPlots, legendRange, grobToPlot,
  plotArgs, nColumns, whPlotObj)

.updateGrobGPTextAxis(sGrob, arr, newArr)

\S4method{.updateGrobGPTextAxis}{.spadesGrob}(sGrob, arr, newArr)
}
\arguments{
\item{grobToPlot}{Graphical object to plot}

\item{sGrob}{spadesGrob object}

\item{takeFromPlotObj}{Logical indicating whether data for grobToPlot should be found in
current call to Plot or from disk}

\item{arr}{An arrangement object}

\item{newArr}{Logical, whether there is a new arrangement happening}

\item{spadesGrobCounter}{Numeric. A counter. No meaning outside Plot function.}

\item{subPlots}{Character. Name of plot area.}

\item{cols}{Color vector.}

\item{whPlotFrame}{Numeric. Which plot within the spadesGrobPlots object.}

\item{spadesSubPlots}{List of many spadesGrobs}

\item{isBaseSubPlot}{Logical. Is the currently being plotted object a base layer}

\item{isNewPlot}{Logical. Is the currenly being plotted object a new, additional plot}

\item{isReplot}{Logical. Is the currently being plotted object a replot due to something
like a rearrangement}

\item{zMat}{List resulting from \code{.convertSpatialToPlotGrob}}

\item{wipe}{Logical. Is the currently being plotted object require a white rectangle to
be plotted first, and subsequent other changes.}

\item{xyAxes}{List of length 2, resulting from \code{.xyAxes}}

\item{legendText}{Character vector of legend value labels.
Defaults to \code{NULL}, which results in a pretty numeric
representation.
If \code{Raster*} has a Raster Attribute Table (rat; see
\code{\link{raster}} package), this will be used by default.
Currently, only a single vector is accepted.
The length of this must match the length of the legend, so
this is mosty useful for discrete-valued rasters.}

\item{vps}{A viewport tree resulting from \code{.makeViewports}}

\item{nonPlotArgs}{Arguments passed to \code{Plot} that are not \code{.spadesPlottables},
but are passed along with \code{.spadesPlottables}.}

\item{legendRange}{Numeric vector giving values that, representing the lower
and upper bounds of a legend (i.e., \code{1:10} or
\code{c(1,10)} will give same result) that will override
the data bounds contained within the \code{grobToPlot}.}

\item{plotArgs}{list. Any arguments that the the grid package can accept for
the specific grob types, e.g., rasterGrob, polygonGrob, etc.}

\item{nColumns}{Numeric, length 1, indicating how many columns are in the device arrangement}

\item{whPlotObj}{Numeric. Length 1, indicating which of the currently objects passed into
\code{Plot} is currently being plotted, i.e., a counter of sorts.}
}
\description{
Not meant to be used by user.
}
\author{
Eliot McIntire
}
\keyword{internal}

