% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.json}
\alias{read.json}
\alias{read.json.default}
\alias{jsonFile}
\alias{jsonFile.default}
\title{Create a SparkDataFrame from a JSON file.}
\usage{
\method{read.json}{default}(path, ...)

\method{jsonFile}{default}(path)
}
\arguments{
\item{path}{Path of file to read. A vector of multiple paths is allowed.}

\item{...}{additional external data source specific named properties.}
}
\value{
SparkDataFrame
}
\description{
Loads a JSON file (\href{http://jsonlines.org/}{JSON Lines text format or newline-delimited JSON}
), returning the result as a SparkDataFrame
It goes through the entire dataset once to determine the schema.
}
\note{
read.json since 1.6.0

jsonFile since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
df <- jsonFile(path)
}
}
