% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.R
\name{circle}
\alias{circle}
\title{Compute cartesian coordinates of a cluster center and radius}
\usage{
circle(geo, cluster.center, cluster.end)
}
\arguments{
\item{geo}{A \code{n x 2} table of the x-coordinate and y-coordinates of the centroids of each area}

\item{cluster.center}{The area index (an integer between \code{1} and \code{n}) indicating the center of the circle}

\item{cluster.end}{The area index (an integer between \code{1} and \code{n}) indicating the area at the end of the circle}
}
\value{
\item{cluster.radius}{A data frame that you can plot}
}
\description{
This function is used for plotting purposes
}
\examples{
data(pennLC)
geo <- pennLC$geo[,2:3]
plot(geo,type='n')
text(geo,labels=1:nrow(geo))
lines( circle(geo, 23, 46), col = "red" )
}
\author{
Albert Y. Kim
}
