#' @title Spatial Position Package
#' @name SpatialPosition
#' @description Computes spatial position models: Stewart 
#' potentials, Reilly catchment areas, Huff catchment areas.
#' @seealso  \link{stewart}, \link{rasterStewart}, \link{plotStewart}, 
#' \link{contourStewart}, \link{huff}, \link{rasterHuff}, \link{plotHuff},\link{reilly}, 
#' \link{rasterReilly}, \link{plotReilly}, 
#' \link{CreateGrid}, \link{CreateDistMatrix}.
#' @docType package
NULL

#' @title Spatial Units of Paris 
#' @description A SpatialPolygonsDataFrame of the 20 spatial arrondissements of the Paris.
#' @name spatUnits
#' @docType data
NULL

#' @title Public Hospitals
#' @description A SpatialPointsDataFrame of 18 public hospitals with their capacity 
#' (Capacite field = number of beds).
#' @name spatPts
#' @docType data
NULL

#' @title Paris Perimeter
#' @description A SpatialPolygonsDataFrame of the Paris perimeter. 
#' @name spatMask
#' @docType data
NULL
