% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stewart.R
\name{rasterStewart}
\alias{rasterStewart}
\title{Create a Raster from a Stewart SpatialPointsDataFrame}
\usage{
rasterStewart(x, mask = NULL)
}
\arguments{
\item{x}{sp object (SpatialPointsDataFrame); output of the \code{stewart} function.}

\item{mask}{sp object (SpatialPolygonsDataFrame); this object is used to clip the raster. (optional)}
}
\value{
Raster of potential values.
}
\description{
This function creates a raster from a regularly spaced 
Stewart SpatialPointsDataFrame (output of the \code{\link{stewart}} function).
}
\examples{
data(spatData)
# Compute Stewart potentials from known points (spatPts) on a
# grid defined by its resolution
mystewart <- stewart(knownpts = spatPts, varname = "Capacite",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 50, longlat = FALSE, mask = spatMask)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart, mask = spatMask)
plot(mystewartraster)
}
\seealso{
\link{stewart}, \link{quickStewart}, \link{plotStewart}, \link{rasterToContourPoly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

