% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stewart.R
\name{rasterStewart}
\alias{rasterStewart}
\title{Create a Raster from a Stewart Regular Grid}
\usage{
rasterStewart(x, mask = NULL)
}
\arguments{
\item{x}{sp or sf object; output of the \code{stewart} 
function.}

\item{mask}{sp or sf object; this object is used to clip 
the raster. (optional)}
}
\value{
Raster of potential values.
}
\description{
This function creates a raster from a regularly spaced 
Stewart points grid (output of the \code{\link{stewart}} function).
}
\examples{
library(raster)
data(hospital)
# Compute Stewart potentials from known points (hospital) on a
# grid defined by its resolution
mystewart <- stewart(knownpts = hospital, varname = "capacity",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 100, mask = paris)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart, mask = paris)
plot(mystewartraster)
}
\seealso{
\link{stewart}, \link{quickStewart}, \link{plotStewart}, 
\link{rasterToContourPoly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}
