\name{loglike.var.names}
\encoding{latin1}
\Rdversion{1.1}
\alias{loglike.var.names}
\title{
  Create Names for Log-likelihood Parameters
}
\description{
  Function that creates a character vector with names for the parameters
  expected by log-likelihood functions. Names are created by extracting
  names from the \code{\link{mesa.data.model}} structure, which in turn
  is derived from \code{\link{mesa.data}} by
  \code{\link{create.data.model}}.
}
\usage{
loglike.var.names(mesa.data.model, all = TRUE)
}
\arguments{
  \item{mesa.data.model}{
    Data structure holding observations, and information regarding which
    \cr geographic and spatio-temporal covariates to use when fitting
    the model. See \cr \code{\link{create.data.model}} and
    \code{\link{mesa.data.model}}.
  }
  \item{all}{
    If \code{TRUE} returns names for all parameters (regression
    parameters followed by \emph{log}-covariance parameters), otherwise
    return only names for the \emph{log}-covariance parameters.
  }
}
\details{
  The parameter names for the regression parameters are created by
  combining \code{"gamma"} with
  \code{dimnames(mesa.data$SpatioTemp)[[3]]} for the spatio-temporal
  covariates and by combining \code{"alpha"},
  \code{colnames(mesa.data$trend)} and \code{colnames(mesa.data$LUR)}
  for the geographic covariates. Using both the names of the temporal
  trends and the geographic covariates allows us to seperate regression
  parameters for the different temporal trends. Of course only
  covariates included in \code{\link{mesa.data.model}} by
  \code{\link{create.data.model}} are used when creating the names.

  For the log-covariance parameters the names are generated by combining
 \code{"log.range"} or \cr \code{"log.sill"} with
 \code{colnames(mesa.data$trend)} (or \code{"nu"} for the residual
 field).
}
\value{
  Returns names of the parameters expected by the log-likelihood
  functions. Returns either names of all parameters, or just names of
  the \emph{log}-covariance parameters.
}
\author{
  \enc{Johan Lindstrm}{Johan Lindstrom}
}
\seealso{
  See the functions \code{\link{loglike}}, \code{\link{loglike.grad}},
  \code{\link{loglike.hessian}}, \code{\link{loglike.dim}}, and \cr
  \code{\link{simulateMesaData}}. See also the data strutures
  \code{\link{mesa.data}} and \code{\link{mesa.data.model}}.
  
  For optimization functions see \code{\link{create.data.model}},
  \code{\link{run.MCMC}}, \code{\link{fit.mesa.model}}, and 
  \code{\link{cond.expectation}}.
}
\examples{
##load the data
data(mesa.data.model)
data(mesa.data)

##Find out in which order parameters should be given
loglike.var.names(mesa.data.model)

##...and for only the covariance parameters.
loglike.var.names(mesa.data.model, all = FALSE)

##Including a spatio-temporal covariate
loglike.var.names( create.data.model(mesa.data) )
}
