% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pwd}
\alias{pwd}
\title{Product Within Distance (Spatially Balanced Sampling).}
\usage{
pwd(dis, niter, nsamp, nrepl)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs of units in the population.}

\item{niter}{Number of iterations for the algorithm. More iterations are better but require more time. Usually 10 is very efficient.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples drawn.}
}
\value{
Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
}
\description{
This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the product of distance as an index of the within sample distance (Product Within Distance, \code{pwd} in short).
To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
}
\examples{
#Example 1
#Draw 20 samples of dimension 15 without constant probabilities
dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
nsamp<-15  #sample size
nrepl<-20  #number of samples to draw
niter<-10  #number of iterations in the algorithm
drawn_samples<-pwd(dis,niter,nsamp,nrepl)  #drawn samples
\donttest{
#Example 2
#Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
#with N=population size
dis<-as.matrix(dist(cbind(lucas_abruzzo$x,lucas_abruzzo$y))) #distance matrix
nsamp<-15  #sample size
nrepl<-20  #number of samples to draw
niter<-10  #number of iterations in the algorithm
vec<-rep(1,nrow(dis)) #vector of constraints
stand_dist<-stprod(dis,vec,1e-15,1000) #standardized matrix
drawn_samples<-pwd(stand_dist,niter,nsamp,nrepl)  #drawn samples
}
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}
}
