% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stsum}
\alias{stsum}
\title{Standardize a symmetric matrix (distances) to fixed row (column) totals.}
\usage{
stsum(mat, vec, differ = 1e-15, niter = 1000L)
}
\arguments{
\item{mat}{A distance matrix size NxN.}

\item{vec}{A vector of row (column) constraints.}

\item{differ}{A scalar with the maximum accepted difference with the constraint (default = 1e-15).}

\item{niter}{An integer with the maximum number of iterations (default = 1000).}
}
\value{
Return a distance matrix constrained size NxN.
}
\description{
\code{stsum} standardizes the distance matrix to fixed rows and columns products for using \code{\link{swd}}.
The function iteratively constrains the rows sums of the matrix to know totals, and in order to keep the symmetry of the matrix, at each iteration performs an average with its transpose.
When the known totals are all equal to a constant (e.g. 1), this method provides a simple and accurate way to scale a distance matrix to a doubly stochastic matrix. The new matrix will not be affected by problems arising from units with different inclusion probabilities, due to not required features of the spatial distribution of the population, such as edge effects and isolated points.
}
\examples{
dis <- as.matrix(dist(cbind(simul2$x, simul2$y))) # distance matrix
con <- rep(1, nrow(dis)) # vector of constraints
stand_dist <- stsum(dis, con) # standardized matrix
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}
}
