% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_lines.R
\name{lines,Splinets-method}
\alias{lines,Splinets-method}
\title{Adding graphs of splines to a plot}
\usage{
\S4method{lines}{Splinets}(x, sID = NULL, ...)
}
\arguments{
\item{x}{\code{Splinets} object;}

\item{sID}{vector, specifying indices of splines in the splinet object to be plotted;}

\item{...}{other standard graphical parameters;}
}
\value{
No return values, the effect are lines (graphs) visualizing a Splinet object added to the current plot. 
The entire set of splines is displayed in the plot.
}
\description{
A standard method of adding splines to an existing plot.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2019) "Splinets -- efficient orthonormalization of the B-splines."  <arXiv:1910.07341>.

Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.
}

\examples{
#-----------------------------------------------------#
#------Adding spline lines to an existing graph-------#
#-----------------------------------------------------#
n=17; k=4; xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1 
set.seed(5)
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))
spl=construct(xi,k,S) 
plot(spl,main="Mean Spline",lty=2,lwd=2)

RS=rspline(spl,5)
plot(RS,main="Random splines around the mean spline" )
lines(spl,col='red',lwd=4,lty=2)

}
\seealso{
\code{\link{plot,Splinets-method}} for graphical visualization of splines;
\code{\link{evspline}} for evaluation of a \code{Splinet}-object;
}
