% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{cv_filter}
\alias{cv_filter}
\title{cv_filter}
\usage{
cv_filter(X, D, y, option)
}
\arguments{
\item{X}{the design matrix}

\item{D}{the response vector}

\item{y}{the linear transform}

\item{option}{options for creating the Knockoff statistics
option$eta  the choice of eta for creating the knockoff copy
option$q the desired FDR control bound
option$method 'knockoff' or 'knockoff+'
option$stage0 choose the method to conduct split knockoff
      'fixed': fixed intercept assignment for PATH ORDER method.
         option$beta : the choice of fixed beta for step 0:
              'mle': maximum likelihood estimator.
              'ridge': ridge regression choice beta with lambda = 1/nu.
              'cv_split': cross validation choice of split LASSO over nu
              and lambda.
              'cv_ridge': cross validation choice of ridge regression
              over lambda.
      'path': take the regularization path of split LASSO as the intercept
              assignment for PATH ORDER method.
      'magnitude': using MAGNITUDE method.
option$lambda: a set of lambda appointed for path calculation
option$nu: a set of nu used for Split Knockoffs
option$k_fold: the fold used in cross validation
option$cv_rule: the rule used in CV
      'min': choose nu with minimal CV loss.
      'complexity': choose nu with minimal model complexity in the range
       of 0.99 * CV_loss <= min(CV_loss).}
}
\value{
result: selected features of Split Knockoffs with CV optimal selection of nu.

CV_loss: the CV loss of Split Knockoffs w.r.t. nu.

nu_optimal: the CV optimal nu.
}
\description{
Split Knockoff filter for structural sparsity problem, using cross validation
}
