% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{renderSqlFile}
\alias{renderSqlFile}
\title{Render a SQL file}
\usage{
renderSqlFile(sourceFile, targetFile, ...)
}
\arguments{
\item{sourceFile}{The source SQL file}

\item{targetFile}{The target SQL file}

\item{...}{Parameter values}
}
\description{
\code{renderSqlFile} Renders SQL code in a file based on parameterized SQL and parameter values,
and writes it to another file.
}
\details{
This function takes parameterized SQL and a list of parameter values and renders the SQL that can
be send to the server. Parameterization syntax: \describe{ \item{@parameterName}{Parameters are
indicated using a @ prefix, and are replaced with the actual values provided in the renderSql
call.} \item{\{DEFAULT @parameterName = parameterValue\}}{Default values for parameters can be
defined using curly and the DEFAULT keyword.} \item{\{if\}?\{then\}:\{else\}}{The if-then-else
pattern is used to turn on or off blocks of SQL code.} }
}
\examples{
\dontrun{
renderSqlFile("myParamStatement.sql", "myRenderedStatement.sql", a = "myTable")
}
}

