% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing_functions.R
\name{plotCorrelations}
\alias{plotCorrelations}
\title{Plot Correlation Matrix}
\usage{
plotCorrelations(
  data_path,
  graph_title = "Correlation Matrix",
  graph_subtitle = "Correlation coefficients labeled."
)
}
\arguments{
\item{data_path}{The full path to the Excel file exported from DeepSqueak}

\item{graph_title}{The title for the graph (there is a default title if not specified)}

\item{graph_subtitle}{The subtitle for the graph (there is a default subtitle if not specified)}
}
\value{
A ggplot2 visualization of the box-plot shown in the viewer window, which can be manually exported.
}
\description{
Plots a box-plot based on principal frequency, grouped by custom labels designated in DeepSqueak.
}
\examples{
\dontrun{plotCorrelations(
  data_path = "inst/extdata/Example_Mouse_Data.xlsx",
  graph_title = "myTitle", graph_subtitle = "myDescription"
)}

}
