% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamppConvert.R
\name{stamppConvert}
\alias{stamppConvert}
\title{Import and Convert}
\usage{
stamppConvert(genotype.file, type = "csv")
}
\arguments{
\item{genotype.file}{the genotype input file. This should be a R matrix object or a file path for a csv file containing the genotype data in either bialleleic AB format or allele 'A' frequency format, or a genlight object containing genotype data}

\item{type}{the type of file the genotype data is being imported from; "csv" = comma seperated file, "r" = data frame in the R workspace, "genlight" = genlight object.}
}
\value{
An object of class data.frame which contains allele frequency data for use in other StAMPP functions
}
\description{
Imports biallelic AB formated or allele A frequency genotype data. If the data is in imported in biallelic AB format this function also converts it to allele frequencies
}
\examples{
# Import example data into the R workspace
data(potato.mini, package="StAMPP")
# Convert to allele frequencies
potato.freq <- stamppConvert(potato.mini, "r")
}
\author{
Luke Pembleton <luke.pembleton at agriculture.vic.gov.au>
}
