% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fittedfitStMoMo.R
\name{fitted.fitStMoMo}
\alias{fitted.fitStMoMo}
\title{Compute fitted values for a Stochastic Mortality Model}
\usage{
\method{fitted}{fitStMoMo}(object, type = c("link", "rates", "deaths"), ...)
}
\arguments{
\item{object}{an object of class \code{"fitStMoMo"} with the fitted
parameters of a stochastic mortality model.}

\item{type}{the type of the fitted values that should be returned. The
alternatives are \code{"link"}(default), \code{"rates"}, and
\code{"deaths"}.}

\item{...}{other arguments.}
}
\value{
A matrix with the fitted values.
}
\description{
Returns fitted values for the data used in fitting a Stochastic Mortality
Model.
}
\examples{
LCfit <- fit(lc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
             ages = EWMaleData$ages, years = EWMaleData$years,
             ages.fit = 55:89)
matplot(LCfit$ages, fitted(LCfit), type = "l", lty = 1,
        col = rainbow(length(LCfit$years)), xlab = "year",
        ylab = "log death rate", main = "Fitted rates")

qxthat <- fitted(LCfit, type = "rates")
qxt <- LCfit$Dxt / LCfit$Ext
plot(LCfit$years, qxt["65", ], xlab = "year", ylab = "death rate",
     main = "fitted vs. observed rates at age 65")
lines(LCfit$years, qxthat["65", ])
}

